/*
 * Decompiled with CFR 0.152.
 */
package tools.javazic;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import tools.javazic.Main;
import tools.javazic.Time;
import tools.javazic.Zone;
import tools.javazic.ZoneRec;
import tools.javazic.Zoneinfo;

class Mappings {
    private Map<String, String> aliases = new TreeMap<String, String>();
    private List<Integer> rawOffsetsIndex = new LinkedList<Integer>();
    private List<Set<String>> rawOffsetsIndexTable = new LinkedList<Set<String>>();
    private List<String> excludeList;

    Mappings() {
    }

    void add(Zoneinfo zoneinfo) {
        String string;
        Map<String, Zone> map = zoneinfo.getZones();
        for (String object : map.keySet()) {
            Object n3;
            int n;
            Object object2 = map.get(object);
            string = ((Zone)object2).getName();
            int n2 = ((Zone)object2).get(((Zone)object2).size() - 1).getGmtOffset();
            boolean bl = false;
            for (n = 0; n < ((Zone)object2).size(); ++n) {
                n3 = ((Zone)object2).get(n);
                if (((ZoneRec)n3).getGmtOffset() == n2 || ((ZoneRec)n3).getUntilTime(0) <= Time.getCurrentTime()) continue;
                if (this.excludeList == null) {
                    this.excludeList = new ArrayList<String>();
                }
                this.excludeList.add(((Zone)object2).getName());
                bl = true;
                break;
            }
            if (!this.rawOffsetsIndex.contains(new Integer(n2))) {
                int n4;
                n = this.rawOffsetsIndex.size();
                for (n4 = 0; n4 < n && this.rawOffsetsIndex.get(n4) <= n2; ++n4) {
                }
                this.rawOffsetsIndex.add(n4, n2);
                TreeSet<String> treeSet = new TreeSet<String>();
                if (!bl) {
                    treeSet.add(string);
                }
                this.rawOffsetsIndexTable.add(n4, treeSet);
                continue;
            }
            if (bl) continue;
            n = this.rawOffsetsIndex.indexOf(new Integer(n2));
            n3 = this.rawOffsetsIndexTable.get(n);
            n3.add(string);
        }
        Map<String, String> map2 = zoneinfo.getAliases();
        if (this.excludeList != null) {
            for (Object object2 : map2.keySet()) {
                string = (String)map2.get(object2);
                if (!this.excludeList.contains(string)) continue;
                this.excludeList.add((String)object2);
            }
        }
        this.aliases.putAll(map2);
    }

    void resolve() {
        int n = this.rawOffsetsIndexTable.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.aliases.keySet()) {
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                Set<String> set = this.rawOffsetsIndexTable.get(i);
                boolean bl3 = bl2 = this.excludeList == null ? false : this.excludeList.contains(string);
                if (!set.contains(this.aliases.get(string)) && !bl2 || !Zone.isTargetZone(string)) continue;
                bl = true;
                if (bl2) break;
                set.add(string);
                Main.info("Alias <" + string + "> added to the list.");
                break;
            }
            if (bl) continue;
            Main.info("Alias <" + string + "> removed from the list.");
            arrayList.add(string);
        }
        for (String string : arrayList) {
            this.aliases.remove(string);
        }
    }

    Map<String, String> getAliases() {
        return this.aliases;
    }

    List<Integer> getRawOffsetsIndex() {
        return this.rawOffsetsIndex;
    }

    List<Set<String>> getRawOffsetsIndexTable() {
        return this.rawOffsetsIndexTable;
    }

    List<String> getExcludeList() {
        return this.excludeList;
    }
}

